VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clspBNLS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal numBYTEs As Long)


Public Sub ParseBNLS(ByVal strData As String)
On Error Resume Next
Dim PacketId As String
PacketId = Asc(Mid$(strData, 3, 1))

    Select Case PacketId
    
    Case BNLS_REQUESTVERSIONBYTE 'Request VerByte from BNLS
        If DBGMode = True Then AddC frmMain.RTB1, vbGreen, "(BNLS) Received (0x10: BNLS_REQUESTVERSIONBYTE)"
        VerByte = GetDWORD(Mid(strData, 8, 4))
        If GetDWORD(Mid(strData, 8, 4)) = 0 Then
            AddC frmMain.RTB1, RGB(90, 90, 90), "(Requested version byte from BNLS was not retrieved. Probably due to an invalid BNLS product ID. (Using user defined version byte now...)"
            Call clsConnFunc.SelectProduct
        Else
            AddC frmMain.RTB1, RGB(90, 90, 90), "(Requested version byte from BNLS: 0x" & Hex(GetDWORD(Mid(strData, 8, 4))) & ")"
        End If
        
        If clsBotVars.BNLS_Use = True Then
            
            'Check to make sure when BNLS the product IS WAR3 since the BNLS connection currently only supports WAR3.
            If clsBotVars.BNLS_Use = True And (clsBotVars.BNLS_ProductID And &H7) <> &H7 And (clsBotVars.BNLS_ProductID And &H8) <> &H8 Then
                MsgBox "The BNLS connection implimented only supports Warcraft III." & vbNewLine & "Please turn BNLS off and add necessary hash files in for the product you are using (" & MakeLongClientName(clsBotVars.Product) & ")", vbCritical, "Error: Connection"
                Exit Sub
            End If
            
            frmMain.sckBNET.Close
            If InStr(clsBotVars.Server, ":") Then
                frmMain.sckBNET.Connect Split(clsBotVars.Server, ":")(0), Split(clsBotVars.Server, ":")(1)
                AddC frmMain.RTB1, vbYellow, "(BNET) Attempting to connect server... ( " & clsBotVars.Server & " )"
            Else
                frmMain.sckBNET.Connect clsBotVars.Server, 6112
                AddC frmMain.RTB1, vbYellow, "(BNET) Attempting to connect server... ( " & clsBotVars.Server & ":6112 )"
            End If
        Else
            frmMain.sckBNLS.Close
        End If
    
    Case BNLS_VERSIONCHECK
        If DBGMode = True Then AddC frmMain.RTB1, vbGreen, "(BNLS) Received (0x09)"
        
        uData.lngVersion = Val("&H" & clsDecodecdkey.StrToHex(StrReverse(Mid$(strData, 8, 4))))
        uData.lngVersion = CLng(uData.lngVersion)
        uData.lngCheckSum = Val("&H" & clsDecodecdkey.StrToHex(StrReverse(Mid$(strData, 12, 4))))
        uData.lngCheckSum = CLng(uData.lngCheckSum)
        uData.strEXEInfo = Mid(strData, 16, Len(strData) - 16)
        
        With clspBuffer
            .InsertDWORD uData.lngServers
            .InsertNTString clsBotVars.cdkey
            .SendBNLSPacket BNLS_CDKEY
            If DBGMode = True Then AddC frmMain.RTB1, vbYellow, "(BNLS) Sent (0x01: BNLS_VERSIONCHECK)"
        End With
    
    Case BNLS_CDKEY
    If DBGMode = True Then AddC frmMain.RTB1, vbGreen, "(BNLS) Received (0x01: BNLS_CDKEY)"
    uData.CDKeyHash = Mid$(strData, 12)
    uData.GTC = Val("&H" & clsDecodecdkey.StrToHex(StrReverse(Mid$(strData, 8, 4))))
    uData.GTC = CLng(uData.GTC)
    Call Send_0x51_BNLS
    
    Case BNLS_CDKEY_EX
        If DBGMode = True Then AddC frmMain.RTB1, vbGreen, "(BNLS) Received (0x0C: BNLS_CDKEY_EX)"
    
    Case BNLS_LOGONCHALLENGE
        If DBGMode = True Then AddC frmMain.RTB1, vbGreen, "(BNLS) Received (0x02: BNLS_LOGONCHALLENGE)"
        With clspBuffer
            .InsertNonNTString Mid(strData, 4)
            .InsertNTString clsBotVars.Username
            .SendPacket SID_AUTH_ACCOUNTLOGON
            If DBGMode = True Then AddC frmMain.RTB1, vbYellow, "(BNLS) Sent (0x53: BNET)"
        End With
    
    Case BNLS_LOGONPROOF
        If DBGMode = True Then AddC frmMain.RTB1, vbGreen, "(BNLS) Received (0x03: BNLS_LOGONPROOF)"
        With clspBuffer
            .InsertNonNTString Mid(strData, 4)
            .SendPacket SID_AUTH_ACCOUNTLOGONPROOF
        End With
        If DBGMode = True Then AddC frmMain.RTB1, vbGreen, "(BNLS) Sent (0x54: BNET)"
    
    Case BNLS_CREATEACCOUNT
        If DBGMode = True Then AddC frmMain.RTB1, vbGreen, "(BNLS) Received (0x04: BNLS_CREATEACCOUNT)"
        With clspBuffer
            .InsertNonNTString Mid$(strData, 4)
            .InsertNTString clsBotVars.Username
            .SendPacket SID_AUTH_ACCOUNTCREATE
            If DBGMode = True Then AddC frmMain.RTB1, vbGreen, "(BNLS) Sent (0x52: BNET)"
        End With
        
    End Select
    
    '/* Plugins:
    Dim i As Integer
    For i = 0 To UBound(Plugins) - 1
        Call Plugins(i).Plugin.Parse_Packets(2, PacketId, strData)
    Next i
    '*/

End Sub

Public Sub Send_BNLSREQUESTVERBYTE()
    With clspBuffer
        .InsertDWORD clsBotVars.BNLS_ProductID
        'Debug.Print "BNLS_PRODUCTID: " & clsBotVars.BNLS_ProductID
        'Debug.Print clsBotVars.Product
        .SendBNLSPacket BNLS_REQUESTVERSIONBYTE
    End With
    If clsBotVars.Product = "3RAW" Then
        With clspBuffer
            .InsertDWORD &H2
            .SendBNLSPacket BNLS_CHOOSENLSREVISION
        End With
        If DBGMode = True Then AddC frmMain.RTB1, vbYellow, "(BNLS) Sent (0x0D)"
    End If
End Sub

Public Sub Send_0x50_BNLS()
    With clspBuffer
        .InsertDWORD &H0
        .InsertNonNTString "68XI" & clsBotVars.Product
        If DBGMode = True Then Debug.Print "Send_0x50_BNLS: " & clsBotVars.Product
        .InsertDWORD VerByte
        .InsertDWORD &H0
        .InsertDWORD &H0
        .InsertDWORD &H480
        .InsertDWORD &H1033
        .InsertDWORD &H1033
        .InsertNTString "USA"
        .InsertNTString "United States"
        .SendPacket SID_AUTH_INFO
        .InsertDWORD &H0
        .SendPacket SID_PING
    End With
End Sub

Private Sub Send_0x51_BNLS()
    If DBGMode = True Then AddC frmMain.RTB1, vbYellow, "(BNET) Sent (0x51: SID_AUTH_CHECK)"
    With clspBuffer
        .InsertDWORD uData.GTC
        .InsertDWORD uData.lngVersion
        .InsertDWORD uData.lngCheckSum
        Debug.Print uData.lngCheckSum
        .InsertDWORD &H1
        .InsertDWORD &H0
        .InsertNonNTString uData.CDKeyHash
        .InsertNTString uData.strEXEInfo
        Debug.Print uData.strEXEInfo
        .InsertNTString clsBotVars.Username 'Register name
        .SendPacket SID_AUTH_CHECK
    End With
End Sub


Private Function GetDWORD(Data As String) As Long
Dim lReturn As Long
    Call CopyMemory(lReturn, ByVal Data, 4)
    GetDWORD = lReturn
End Function
